/****
 *	FileMgr.h --- this a C only version of the CFileMgr.h/.c file
 *
 *	Class to manage files in the compiler parts.  This class
 *	is used to keep track of file information in one place.  All other
 *	parts of the system can query a global instance of this class to
 *	get information about file locations.
 *
 *
 *	The application deals with four (possibly) different folders.
 *	1) Application Folder - folder where GWAda is stored.
 *
 *	2) Compiler Folder - folder where the compiler parts
 *	are stored.  They all must be stored in the same directory.
 *
 *	3) User Source Folder - folder where a source file is stored.  This might
 *	be different for each source file.
 *
 *	4) User Library Folder - folder where the user library is stored.
 *
 *	Uses of these folders:
 *
 *	Application Folder (AppFolder)
 *	- Application must be stored there (GWAda).
 *
 *	Compiler Folder (CmpFolder)
 *	- Command line options are written here.  These are files written
 *	  by GWAda and read by the compiler parts.  The compiler parts
 *	  delete these files.  The file name is <part>.options.
 *
 *	- Result files from the compiler parts are written here with
 *	  file name <part>.return.  For example, for adabind, the result
 *	  file would be 'adabind.result'.  Adaexec doesn't write a result
 *	  file.  Written by the compiler parts and deleted by GWAda.
 *
 *	- The predef library (3 files) is stored in the folder also.
 *
 *
 *	User Source Folder (UsrFolder)
 *	- User's source files.
 *
 *	- Listing files are written here by GWAda.  Nothing is ever deleted
 *	  from here execpt the listing files, which get overwritten.
 *
 *
 *	User Library Folder (LibFolder)
 *	- AdaEd results are written here.  All aic, trc, axq, etc. files
 *	  are written here.  The library file (lib) is also stored here.
 *
 *	- msg files are written here by adafront and adagen.  These are
 *	  read by GWAda and processed into a lis file.  The msg is then
 *	  deleted.
 *
 *	- err files are written here by adafront, adagen, and adabind.
 *	  These are internal error files; they contain the text message
 *	  that would have been printed to the console in the other AdaEd
 *	  systems.  Never deleted unless overwritten.
 *
 *
 *	Exception:
 *	The current implementation uses the same folder as AppFolder for
 *	the CmpFolder.
 *
 ****/

/*
 * Copyright (C) 1985-1992  New York University
 * Copyright (C) 1994 George Washington University
 * 
 * This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
 * system.  See the Ada/Ed README file for warranty (none) and distribution
 * info and also the GNU General Public License for more details.
 */


#pragma once


void	IFileMgr(void);

// Application folder management
void	SetApplicationFolder(const FSSpecPtr appl);	// called at startup
void	GetApplicationFolder(FSSpecPtr appl);
void	GetApplicationPath(Str255 path);


// Compiler folder management
void	SetCompilerFolder(const FSSpecPtr comp);		// called at startup
void	GetCompilerFolder(FSSpecPtr comp);
void	GetCompilerPath(Str255 path);

// Compiler part identifier
void	SetPartName(Str255 name);		// called when compiler part starts
void	GetPartName(Str255 name);


// User Library folder management
void	SetLibraryFolder(const FSSpecPtr lib);		// called when lib is opened
void	GetLibraryFolder(FSSpecPtr lib);
void	GetLibraryPath(Str255 path);



// User Source (being compiled)
void	SetSource(const FSSpecPtr src);		// called when user selects command
void	GetSource(FSSpecPtr src);
void	GetSourceName(Str255 name);
void	GetSourceFolder(Str255 folder);		// path without name

// Special case: Binding and Execute Unit Name
void	SetUnitName(Str255 name);
void	GetUnitName(Str255 name);

void	GetOptionsFile(Str255 name);	// CompFolder:PartName.options
void	GetReturnFile(Str255 name);		// CompFolder:PartName.return
void	GetLisFile(Str255 name);		// UsrFolder:SourceName.lis

								// SourceName is UnitName if binding/executing
void	GetMsgFile(Str255 name);		// LibFolder:SourceName.msg
void	GetErrFile(Str255 name);		// LibFolder:SourceName.err
void	GetConsoleOutputFile(Str255 name);	// LibFolder:SourceName.output
void	GetDataFilePath(Str255 name);		// LibFolder::

// end of file
